<?php
// Inclui funções e inicia a sessão
include "includes/functions.php";

if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Verifica se o usuário está logado
$log_check = $db->select("users", "*", "id = :id", "", [":id" => 1]);
$loggedinuser = !empty($log_check) ? $log_check[0]["username"] : NULL;
if (!empty($loggedinuser) && isset($_SESSION["name"]) && $_SESSION["name"] === $loggedinuser) {
    header("Location: dns.php");
    exit;
}

// Insere o usuário admin se não existir
$data = ["id" => "1", "username" => "admin", "password" => "admin"];
$db->insertIfEmpty("users", $data);

// Processa o login
if (isset($_POST["login"])) {
    $username = $_POST["username"];
    $userData = $db->select("users", "*", "username = :username", "", [":username" => $username]);
    if ($userData) {
        $storedPassword = $userData[0]["password"];
        if ($_POST["password"] === $storedPassword) {
            session_regenerate_id();
            $_SESSION["loggedin"] = true;
            $_SESSION["name"] = $_POST["username"];
            header($_POST["username"] == "admin" ? "Location: user.php" : "Location: dns.php");
        } else {
            header("Location: ./api/index.php");
        }
    } else {
        header("Location: ./api/index.php");
    }
    $db->close();
}

// Variáveis para descrição e links
$descriptionText1 = <<<HTML
<span style="color: white; font-size: 16px;">
    Mod do Painel e Aplicativo idealizado por<br> 
    <span style="color: red; font-size: 20px; text-decoration: underline;">Cyber Tv Scripts</span><br>
    e equipe<br>
    <span style="color: red; font-size: 20px; text-decoration: underline;">Cyber Tv Scripts</span>
</span>
HTML;

$descriptionLink = "https://contato.s3dmidia.com.br"; // Adicione o link desejado aqui
$descriptionLinkText = <<<HTML
<a href="$descriptionLink" target="_blank" style="color: blue; text-decoration: underline;">
    Clique aqui para suporte
</a>
HTML;

$descriptionText2 = <<<HTML
<span style="color: white; font-size: 16px;">
    Este é o segundo campo de descrição. Você pode copiar este texto.
</span>
HTML;



$file_name = './codigo_json.json';
$json_data = file_get_contents($file_name);

if ($json_data === false) {
    die("Erro ao ler o arquivo JSON.");
}

// 2. Converter a String JSON para um Array PHP
$data = json_decode($json_data, true); // Passar true para obter um array associativo

$codigo = $data['codigo'];


// HTML da página
echo <<<HTML
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="author" content="IBO RENOVA AUTO">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/css/bootstrap.min.css">
    <link rel="stylesheet" href="./css/css.css">
    <title>IBO RENOVA AUTO</title>
    <style>
        body {
            background-color: #181828;
            background-image: url("./img/binding_dark.webp");
            color: #fff;
        }
        #particles-js {
            background-size: cover;
            background-position: 50% 50%;
            background-repeat: no-repeat;
            background: #8000FF;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        .particles-js-canvas-el {
            position: fixed;
        }
        .container-custom {
            background-color: rgba(0, 0, 0, 0.93);
            padding: 20px;
            border-radius: 10px;
            width: 100%;
            max-width: 400px;
            margin: auto;
            position: relative;
            z-index: 1;
        }
        .description {
            color: #fff;
            font-weight: bold;
            text-align: center;
            margin-top: 15px;
        }
        .description-link {
            color: blue;
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <div id="js-particles"></div>
    <br><br>
    <div class="container-custom">
        <div class="text-center">
            <!-- Logo exibida na página -->
            <img class="w-75 p-3" src="./img/logo.png" alt="Logo">
        </div>
        <form method="post">
            <div class="form-group">
                <!-- Campo de entrada para o nome de usuário -->
                <input type="text" class="form-control form-control-lg" placeholder="Username" name="username" required autofocus>
            </div>
            <div class="form-group">
                <!-- Campo de entrada para a senha -->
                <input type="password" class="form-control form-control-lg" placeholder="Password" name="password" required>
            </div>
            <!-- Botão para fazer login -->
            <input type="submit" class="btn btn-warning btn-lg btn-block" value="Log In" name="login">
            <br>
            <!-- Botão para baixar o aplicativo -->
            <a class="btn btn-primary btn-lg btn-block" href="./Zing-Play-IBO.apk" download>Baixar Aplicativo</a>
        </form>
    </div>
    
    <br><br>

  
    <br>
    <br>
    
    <script src="https://code.jquery.com/jquery-3.3.1.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.3/umd/popper.min.js" integrity="sha384-ZMP7rVo3mIykV+2+9J3UJ46jBk0WLaUAdn689aCwoqbBJiSnjAK/l8WvCWPIPm49"
    crossorigin="anonymous"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/js/bootstrap.min.js" integrity="sha384-ChfqqxuZUCnJSK3+MXmPNIyE6ZbWh2IMqE241rYiqJxyMiZ6OW/JmZQ5stwEULTy" 
    crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <!-- <script src="js/particles.js"></script>-->
    
</body>
</html>
HTML;
?>