<?php
ini_set('display_errors', 0);

// Caminho do banco de dados
define('DB_PATH', './api/.boxbrdb.db');
define('MAX_ATTEMPTS', 3); // Número máximo de tentativas por URL

// Função para verificar se há conexão com a internet
function checkConnection($pingUrl = 'https://www.google.com') {
    $ch = curl_init($pingUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10); // Timeout de 10 segundos
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10); // Timeout de conexão de 10 segundos
    curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    return ($httpCode === 200); // Retorna true se a resposta for 200 (OK)
}

// Inicializa o banco de dados
function initDatabase($dbPath) {
    if (!file_exists($dbPath)) {
        die("Banco de dados não encontrado.");
    }
    return new SQLite3($dbPath);
}

// Carrega as URLs dos DNS do banco de dados
function loadDnsUrls($db) {
    $urls = [];
    $query = $db->query("SELECT url FROM dns");
    while ($row = $query->fetchArray(SQLITE3_ASSOC)) {
        $urls[] = $row['url'];
    }
    return $urls;
}

// Função para obter um User Agent aleatório
function getRandomUserAgent() {
    $userAgents = [
        "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/115.0.0.0 Safari/537.36",
        "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.5735.199 Safari/537.36",
        "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/110.0.0.0 Safari/537.36",
        "Mozilla/5.0 (iPhone; CPU iPhone OS 15_5 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/15.5 Mobile/15E148 Safari/604.1",
        "Mozilla/5.0 (Linux; Android 11; SM-G991B) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.5615.137 Mobile Safari/537.36",
        "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.81 Safari/537.36",
        "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:90.0) Gecko/20100101 Firefox/90.0",
        "Opera/9.80 (Windows NT 6.1; WOW64) Presto/2.12.388 Version/12.18",
        "Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.1; Trident/6.0)",
        "Mozilla/5.0 (Windows NT 6.3; rv:36.0) Gecko/20100101 Firefox/36.0",
    ];

    return $userAgents[array_rand($userAgents)];
}

// Função para executar a requisição cURL
function getResult($url, $userAgent) {
    $badStatusCodes = [404, 401, 502, 500];
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_HEADER, 0);
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_USERAGENT, $userAgent);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_AUTOREFERER, true);
    $html = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    // Verifica se o código de status é um dos códigos de erro
    if (in_array($httpCode, $badStatusCodes)) {
        return false;
    }

    // Verifica se o conteúdo retornado é válido
    if (!is_string($html) || empty($html)) {
        return false;
    }

    return ['response' => $html, 'http_code' => $httpCode];
}

// Inicialização principal
if (!checkConnection()) {
    echo "Erro: Sem conexão com a internet.";
    exit;
}

// Inicializa o banco de dados
$db = initDatabase(DB_PATH);
$dnsUrls = loadDnsUrls($db);

// Receber parâmetros de query
$username = $_GET['username'] ?? '';
$password = $_GET['password'] ?? '';

// Construir query
$queryString = http_build_query($_GET);

// Tentativas de requisição para cada URL de DNS
foreach ($dnsUrls as $portal) {
    if (!empty($portal)) {
        $url = "{$portal}/player_api.php?{$queryString}";

        for ($attempt = 1; $attempt <= MAX_ATTEMPTS; $attempt++) {
            $userAgent = getRandomUserAgent();
            $result = getResult($url, $userAgent);

            if ($result && $result['http_code'] === 200) {
                // Redireciona para a URL se a resposta for válida
                header("HTTP/1.1 301 Moved Permanently");
                header("Location: {$url}");
                exit;
            }

            // Se a URL retornar um código 301, registra o erro e sai do loop
            if ($result && $result['http_code'] === 301) {
                error_log("Redirecionamento detectado: {$url}");
                break;
            }
        }
    }
}

// Se nenhuma URL for válida, exibe "Falhou"
echo "Falhou";
?>
