<?php
session_start();

date_default_timezone_set('America/Sao_Paulo');

$db = new SQLite3('./api/.logs.db');
$db->exec('CREATE TABLE IF NOT EXISTS logs(id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, date TEXT, ipaddress TEXT)');

function getUserIP() {
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        return $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        return explode(',', $_SERVER['HTTP_X_FORWARDED_FOR'])[0];
    } else {
        return $_SERVER['REMOTE_ADDR'];
    }
}

if (!isset($_GET['delete']) && !isset($_POST['clear_logs'])) {
    $ip = getUserIP();
    $date = date('Y-m-d H:i:s');
    $stmt = $db->prepare('INSERT INTO logs (date, ipaddress) VALUES (:date, :ip)');
    $stmt->bindValue(':date', $date, SQLITE3_TEXT);
    $stmt->bindValue(':ip', $ip, SQLITE3_TEXT);
    $stmt->execute();
}

if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $db->exec("DELETE FROM logs WHERE id = $id");
    header('Location: snoop.php');
    exit();
}

if (isset($_POST['clear_logs'])) {
    $db->exec('DELETE FROM logs');
    header('Location: snoop.php');
    exit();
}

$res = $db->query('SELECT * FROM logs ORDER BY id DESC');

?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Snoop</title>
    <script src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #000;
            color: white;
            margin: 0;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }

        #particles-js {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 0; /* Particles above the black background */
        }

        header {
            position: relative;
            z-index: 2; /* Place header above particles */
            /* Add any header specific styling here if needed */
        }

        main {
            position: relative;
            z-index: 1;
            padding-top: 80px; /* Increased padding-top to create space for the header */
            padding-bottom: 20px;
            flex-grow: 1;
        }

        .h3 {
            color: #1cc88a;
            margin-bottom: 20px;
            text-align: center;
        }

        .table-responsive {
            background-color: rgba(50, 50, 50, 0.8);
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 20px;
        }

        .table {
            color: white;
            margin-bottom: 0;
        }

        .table thead.text-primary th {
            color: #1cc88a;
        }

        .table tbody tr:nth-child(even) {
            background-color: rgba(70, 70, 70, 0.7);
        }

        .btn-icon {
            color: red !important;
        }

        .modal-content {
            background-color: #333;
            color: white;
            border: 1px solid #555;
        }

        .modal-header h2 {
            color: #1cc88a;
        }

        .modal-body {
            color: #ccc;
        }

        .btn-default {
            background-color: #555;
            color: white;
            border: 1px solid #777;
        }

        .btn-danger {
            background-color: #d9534f;
            color: white;
            border: 1px solid #d43f3a;
        }

        .btn-clear-logs {
            background-color: #f0ad4e;
            color: white;
            border: 1px solid #eea236;
            padding: 8px 16px;
            border-radius: 5px;
            cursor: pointer;
            font-size: 14px;
        }

        .btn-clear-logs:hover {
            background-color: #eea236;
        }

        .top-bar {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 15px;
            padding: 0 15px;
        }

        .top-bar-left {
            flex: 1;
        }

        footer {
            position: relative;
            z-index: 2;
            padding: 10px;
            text-align: center;
            color: white;
        }
    </style>
</head>
<body>

   

    <div id="particles-js"></div>   <?php include 'includes/header.php'; ?>

    <main>
        <div class="container">
            <div class="row justify-text-center">
                <div id="main" class="w-100">
                    <h1 class="h3 mb-1 text-gray-800">Snoop</h1>

                    <div class="top-bar">
                        <div class="top-bar-left">
                            <form method="post">
                                <button type="submit" name="clear_logs" class="btn btn-warning btn-clear-logs">🗑️ Limpar Logs</button>
                            </form>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-striped table-sm">
                            <thead class="text-primary">
                                <tr>
                                    <th>IP Address</th>
                                    <th>Date</th>
                                    <th>Delete</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php while ($row = $res->fetchArray()): ?>
                                    <tr>
                                        <td><?= htmlspecialchars($row['ipaddress']) ?></td>
                                        <td><?= htmlspecialchars($row['date']) ?></td>
                                        <td>
                                            <a class="btn btn-icon" href="#" data-href="./snoop.php?delete=<?= $row['id'] ?>" data-bs-toggle="modal" data-bs-target="#confirm-delete">
                                                <span class="icon text-white-50">
                                                    <i class="fa fa-trash" style="font-size:24px;color:red"></i>
                                                </span>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endwhile; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="confirm-delete" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h2>Confirm</h2>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-hidden="true"></button>
                    </div>
                    <div class="modal-body">
                        Do you really want to delete this log?
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-bs-dismiss="modal">Cancel</button>
                        <a class="btn btn-danger btn-ok">Delete</a>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <footer>
        <?php include 'includes/footer.php'; ?>
    </footer>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const modal = document.getElementById('confirm-delete');
            modal.addEventListener('show.bs.modal', function (e) {
                const href = e.relatedTarget.getAttribute('data-href');
                modal.querySelector('.btn-ok').setAttribute('href', href);
            });
        });

        particlesJS('particles-js', {
            "particles": {
                "number": { "value": 80, "density": { "enable": true, "value_area": 800 } },
                "color": { "value": "#1cc88a" },
                "shape": { "type": "circle" },
                "opacity": { "value": 0.5, "random": true },
                "size": { "value": 3, "random": true },
                "line_linked": { "enable": true, "distance": 150, "color": "#1cc88a", "opacity": 0.4, "width": 1 },
                "move": { "enable": true, "speed": 6 }
            },
            "interactivity": {
                "events": {
                    "onhover": { "enable": true, "mode": "repulse" },
                    "onclick": { "enable": true, "mode": "push" }
                }
            },
            "retina_detect": true
        });
    </script>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <?php
    require 'includes/boxbr.php';
    ?>
</body>
</html>